function List=BCN_Struct(s,S)
% function List=BCN_Struct(s,S)
% make a list [iPer iLay iRow iCol rest]
% where rest depends on the string
% S which may be 'WEL' 'DRN' 'RIV' 'GHB'
% The function is used to generage boundary condition lists from the struct
% used to construct the groundwater model of the Amsterdam Water Supply
% TO 100528

 switch S
    case 'WEL'  % [iPer iL iR iC Q]
%        L=5; ACTIVE=~isnan(s.flow);
         L=9; ACTIVE=~isnan(s.flow); % 4 add out: iObj #well_in_cell #wells_of_obj Flow_of_obj
    case 'DRN' % [iPer iL iR iC Elev Cond]
         L=6; ACTIVE=~isnan(s.head);
    case 'GHB' % [iPer iL iR iC Head Cond] 
         L=6; ACTIVE=~isnan(s.head);
    case 'RIV' % [iPer iL iR iC Head Conc RBot]
         L=7; ACTIVE=~isnan(s.head);
    otherwise
         error('Illegal arguments %s in BCN_struct',S);
end
 
NOBJ=length(s.gis_id);

%Prevent dynamic memory allocation, first count lenght of list
NLine=0;
for iPer=1:length(s.itmp)
    for iObj=1:NOBJ
        if s.active(iObj) && ACTIVE(iObj,iPer)
            NLine=NLine+length(find(s.code==s.gis_id(iObj)));
        end
    end
end

List=NaN(NLine,L);
iLine=0;
for iPer=1:length(s.itmp)
    for iObj=1:NOBJ
        if s.active(iObj) && ACTIVE(iObj,iPer)
            I=find(s.code==s.gis_id(iObj));
            J=iLine+(1:length(I))';
            List(J,1)=iPer;
            List(J,2)=s.layer(iObj);
            List(J,3)=s.row(I);
            List(J,4)=s.col(I);
            switch S
                case 'WEL'
                    List(J,5)=s.flow(iObj,iPer).*s.numb(I)/s.wells(iObj);
                    List(J,6)=iObj;
                    List(J,7)=s.numb(I);
                    List(J,8)=s.wells(iObj);
                    List(J,9)=s.flow(iObj,iPer); % Total flow for total object
                case 'DRN'
                    if isfield(s,'length'),
                        List(J,5)=s.head(iObj,iPer);
                        List(J,6)=s.length(I)./s.resistance(iObj);
                    elseif isfield(s,'mp')
                        List(J,5)=s.mp(I);
                        List(J,6)=s.area(I)./s.resistance(iObj);
                    else
                        List(J,5)=s.head(iObj,iPer);
                        List(J,6)=s.area(I)./s.resistance(iObj);
                    end
                case 'GHB'
                    List(J,5)=s.head(iObj,iPer);
                    List(J,6)=s.area(I)/s.resistance(iObj);
                case 'RIV'
                    List(J,5)=s.head(iObj,iPer);
                    List(J,6)=s.area(I)/s.resistance(iObj);
                    List(J,7)=s.depth(iObj);
            end
            iLine=iLine+length(I);
        end
    end
end
